//
//  MCDataContextRegistry.h
//  MCApplication
//
//  Created by aj on Mon Aug 27 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

/*
The class provides a clean way of getting objects that connect to a datastore. The datastore can be anything, an EOF stack, an ObjC database stack, an ObjC file stack. Controllers ask for their backend connect using the singleton of this class.

A config file (context.config) is read from the app wrapper. That config file is consulted before actual intantiation happens. The config file also contains info about initialization classes. Before a context is instantiated, the initializer is run and put into a dictionary. Multiple contexts can have the same initializer class. An initializer class is run only once and the initializer class must do all it's initialization work in the setupForContexts method. (i.e. connecting to the database, asking the user for 


{
    "language" = "Java";
#   "language" = "ObjC";    
    "context name" = {
                        classname = "a classname";
                        initializerClass = "another classname";
                    };
                    
}


*/


@interface MCDataContextRegistry : NSObject {

    NSDictionary 		*config;
    NSMutableDictionary		*initializerInstances;

}

+ (MCDataContextRegistry *)defaultDataContextRegistry;

// Returns YES if java is required
- (BOOL)requiresJava;

// Returns a fresh, autoreleased context object
- (id)contextNamed:(NSString *)aName;

// returns the allocation instance of the initializer class, setupForContexts is not called if this is first call
- (id)initializerForContextNamed:(NSString *)aName;


@end


@interface NSObject (MCDataContextInitializerSupport)

/*
All initializers must respond to this method! This is where all data store connection and setup must run

*/

- (void)setupForContexts;
@end
